function [groupLabels leavesDict2] = partitionDendrogram(L,p,leavesDict,pPrev,groupsPrev)
%PARTITIONDENDROGRAM  Partition a dendgrogram at distance level p, and
%return the resulting community labels for numbered nodes
%L should be the result of the linkage function

%N is number of leaves in dendrogram
N = size(L,1) + 1;

groupLabels = groupsPrev;

%Groups is a cell array of vectors of different size, giving the group
%members
% groups = {};



currCom = 1;
for i = 1:(N-1)

    if L(i,3) < pPrev
        continue;
    elseif L(i,3) < p
        % If this split is below the threshold
        % Inefficient code - needs to be optimized
        leaves = findLeaves(i+N);
        
        groupNum = unique(groupLabels(leaves));
        groupNum = max(groupNum);

        if groupNum == 0
%             groups = [groups; {leaves}];
            groupLabels(leaves) = currCom;
            currCom = currCom+1;
%         disp('hi')
%G
        else
            groupLabels(leaves) = groupNum;

        end
    end
end

% Need to compress group labels if groups have disappeared
currLabs = unique(groupLabels(groupLabels>0));
for i = 1:numel(currLabs)
    groupLabels(groupLabels==currLabs(i)) = i;
end

leavesDict2 = leavesDict;
% Everything that has not been assigned to a group gets its own group label
% for i = 1:numel(groupLabels)
%     if groupLabels(i) == 0
%         groupLabels(i) = currCom;
%         currCom = currCom + 1;
%     end
% end

    function leaves = findLeaves(groupNum)
        if groupNum<=N
            leaves = groupNum;
        else
            if isempty(leavesDict{groupNum-N})
                leaves = [findLeaves(L(groupNum-N,1)) findLeaves(L(groupNum-N,2))];
                leavesDict{groupNum-N} = leaves;
            else
                leaves = leavesDict{groupNum-N};
%                 disp(groupNum);
            end
            
        end
    end

end

